//
//FlashLIGHT NEO
//TEAM Redhering 2019/2/15
//
//[A]FlashLIGHT
//[B]REDSCANNER
//[A]+[B]LANTERN
//[C]CHANGE FUNCTION
//
#include <Adafruit_NeoPixel.h>
#include "M5StackUpdater.h"

#define M5STACK_FIRE_NEO_NUM_LEDS 10
#define M5STACK_FIRE_NEO_DATA_PIN 15
//
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(M5STACK_FIRE_NEO_NUM_LEDS, M5STACK_FIRE_NEO_DATA_PIN, NEO_GRB + NEO_KHZ800);
int pt_ad;
int p_mode, s_mode, s_mode_t;
int led_col[M5STACK_FIRE_NEO_NUM_LEDS];
//
//M5 STACK SYSTEM SETUP
void setup()
{
  M5.begin();
  //SD_MENU_KICK
  if (digitalRead(BUTTON_A_PIN) == 0) {
    Serial.println("Will Load menu binary");
   // if (digitalRead(BUTTON_B_PIN) == 0)
   //   updateFromFS(SD, "/menu_n.bin");
   //  else
    updateFromFS(SD);
    ESP.restart();
  }
  //DISPLAY OFF
  M5.Lcd.writecommand(ILI9341_DISPOFF);
  M5.Lcd.setBrightness(0);
  //NEO PIXEL START & Lights off
  delay(100);
  pixels.begin();
  delay(200);
  LED_Clear();
  pixels.setBrightness(0);
  randomSeed(analogRead(0));
}
//M5 STACK SYSTEM LOOP
void loop()
{
  //***
  //MODE CHANGE
  //***

  //[RESET]
  if (digitalRead(BUTTON_A_PIN) == 0 && digitalRead(BUTTON_B_PIN) == 0 && digitalRead(BUTTON_C_PIN) == 0) {
    LED_Clear();
    p_mode = 0;
    delay(500);
  }
  else
    //[LANTERN]
    if (digitalRead(BUTTON_A_PIN) == 0 && digitalRead(BUTTON_B_PIN) == 0) {
      LED_Clear();
      p_mode = 3; pixels.setBrightness(255);
    }
    else
      //[FlashLIGHT]
      if (digitalRead(BUTTON_A_PIN) == 0) {
        LED_Clear();
        p_mode = 1; pixels.setBrightness(255);
      }
      else
        //[REDSCANNER]
        if (digitalRead(BUTTON_B_PIN) == 0) {
          LED_Clear();
          p_mode = 2;
        }
  //[SUBMODE SET]Toggle operation
  if (digitalRead(BUTTON_C_PIN) == 0 && s_mode_t == 0) {
    s_mode++; s_mode %= 2; s_mode_t = 1;
  }
  else
    s_mode_t = 0;

  //***
  //FUNCTION
  //***
  switch (p_mode) {
    case 1://[FlashLIGHT]
      pt_ad++; pt_ad %= 2;
      if (s_mode == 1 || (s_mode == 0 && pt_ad == 0))
        for (int i = 0; i < 5; i++)pixels.setPixelColor(i, 0xffffff);
      else
        for (int i = 0; i < 5; i++)pixels.setPixelColor(i, 0);
      pixels.show();
      if (s_mode == 1)delay(200);//Flashing mode
      else
        delay(500);
      break;
    case 2://[REDSCANNER]
      //Dimming
      for (int i = 0; i < 5; i++) {
        led_col[i] -= 192;
        if (led_col[i] < 0)led_col[i] = 0;
      }
      //Ignition
      if (pt_ad < 5)led_col[pt_ad] = 255;
      else
        led_col[8 - pt_ad] = 255;
      //
      for (int i = 0; i < 5; i++)pixels.setPixelColor(i, led_col[i] << 16);
      pt_ad++; pt_ad %= 8;
      pixels.show();
      delay(150);
      //
      if (s_mode == 1)pixels.setBrightness(255);//Strong light
      else
        pixels.setBrightness(96);
      break;
    case 3://[LANTERN]
      if (s_mode == 0)
      {
        //White
        for (int i = 0; i < M5STACK_FIRE_NEO_NUM_LEDS; i++) {
          pixels.setPixelColor(i, 0xffffff);
        }
        pixels.setBrightness(255);
        pixels.show();
        delay(500);
      }
      else
      {
        //FIRE
        //Dimming
        for (int i = 0; i < M5STACK_FIRE_NEO_NUM_LEDS; i++) {
          led_col[i] -= 96;
          if (led_col[i] < 0)led_col[i] = 0;
        }
        //Ignition
        led_col[random(10)] = 255;
        //
        for (int i = 0; i < M5STACK_FIRE_NEO_NUM_LEDS; i++)pixels.setPixelColor(i, led_col[i] << 16);
        pt_ad++; pt_ad %= 8;
        pixels.show();
        delay(150);
      }
      break;
  }
}
//
void LED_Clear() {
  for (int i = 0; i < M5STACK_FIRE_NEO_NUM_LEDS; i++)pixels.setPixelColor(i, 0xff);
  pixels.show();//Blue light emission to clear
  delay(200);
  for (int i = 0; i < M5STACK_FIRE_NEO_NUM_LEDS; i++)pixels.setPixelColor(i, 0);
  pixels.show();//Clear
  pixels.setBrightness(0);
}
